<?php
/*--------------------------------------------------------------------
 ReadService.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitWeight\Database\Service;

use Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\DTO\CombisIdDto;
use Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\DTO\WeightDto;
use Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\RepositoryInterface;

/**
 * Class ReadService
 * @package Gambio\Shop\Properties\SellingUnitWeight\Database\Service
 */
class ReadService implements ReadServiceInterface
{
    /**
     * @var RepositoryInterface
     */
    protected $repository;
    
    
    /**
     * ReadService constructor.
     *
     * @param RepositoryInterface $repository
     */
    public function __construct(RepositoryInterface $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function combinationWeight(CombisIdDto $dto): WeightDto
    {
        return $this->repository->combinationWeight($dto);
    }
}